<?php

namespace Import\ApiBundle\Services\Allegro;


use Import\ApiBundle\Services\DataStructure\AllegroDoShowCatDataStructure;

class AllegroWebAPISoapClient extends \SoapClient
{
    /**
     * @var \Symfony\Component\DependencyInjection\Container
     */
    protected $Container;

    protected $errors = array();

    // jedynka to kod kraju dla Polski, o tym dalej
    const COUNTRY_PL = 1;

    const QUERY_ALLEGROWEBAPI = 1;

    public $verKey;
    protected $verKey_url = 'verkey.txt';

    public $session;

    private $user_key;
    private $user_login;
    private $user_pass;

    public function __construct(\Symfony\Component\DependencyInjection\Container $Container)
    {
        parent::__construct('http://webapi.allegro.pl/uploader.php?wsdl');
        $this->Container = $Container;
    }

    public function init()
    {
        try
        {
            $this->_setParams();
            $this->_getVerKeyFromFile();
            $this->_login();
        }
        catch (\SoapFault $error)
        {
            $this->soapFaultError($error);
        }
    }

    public function getVerKey()
    {
        return $this->verKey;
    }

    public function getCatsData()
    {
        try
        {
            return $this->doGetCatsData(self::COUNTRY_PL,0,$this->user_key);
        }
        catch (\SoapFault $error)
        {
            $this->soapFaultError($error);
        }
    }

    public function getCatsDataLimit()
    {
        try
        {
            return $this->doGetCatsDataLimit(self::COUNTRY_PL,0,$this->user_key,0);
        }
        catch (\SoapFault $error)
        {
            $this->soapFaultError($error);
        }
    }

    public function showCat(AllegroDoShowCatDataStructure $DoShowCatDataStructure)
    {
        if(!$DoShowCatDataStructure->validate())
        {
            echo "\r\n"."NOT VALTDATE"."\r\n";
            return false;
        }

        try
        {
            return $this->__soapCall('doShowCat', $DoShowCatDataStructure->getTableParam());
        }
        catch (\SoapFault $error)
        {
            $this->soapFaultError($error);
        }

    }

    public function getSellFormAttribs($cat_id)
    {
        try
        {
            return $this->doGetSellFormAttribs(self::COUNTRY_PL,$this->user_key,0,$cat_id);
        }
        catch (\SoapFault $error)
        {
            $this->soapFaultError($error);
        }
    }

    public function search()
    {
        $searchQuery = array(
            'search-string' => 'ZESTAW',
            'search-options' => 19,//36,
            //1 - bierz pod uwagę którekolwiek z wpisanych słów, 2 - w opisach, 4 - ostatnie 24 godzin,
            //8 - tylko Kup Teraz!, 16 - w zakończonych, 32 - w mieście użytkownika, 64 - w województwie użytkownika,
            //128 - pomiń Erotyka, 256 - z dostawą 'Odbiór w punkcie', 512 - zakup bez rejestracji,
            //1024 - wysyłka gratis, 2048 - oferty Standard Allegro [PL]/Aukro Plus [CZ]/Super Offer [UA/KZ],
            //4096 - wysyłka za pośrednictwem NovayaPochta [UA]), 8192 - tylko licytacje, 16384 - także "podobne",
            //32768 - tylko w "Nowy", 65536 - tylko w "Używany")
            'search-order' => 8,
            //1 - po czasie zakończenia, 2 - po liczbie złożonych ofert, 4 - po cenie przedmiotu, 8 - alfabetycznie po tytule oferty
            'search-order-type' => 1,
            //0 - rosnąco, 1 - malejąco
            'search-country' => self::COUNTRY_PL,
            'search-category' => 2,//181,//0,
            'search-offset' => 0,
            'search-city' => '',
            'search-state' => 0,
            'search-price-from' => 0.00,
            'search-price-to' => 0.00,
            'search-limit' => 50,
            'search-order-fulfillment-time' => 999,
            'search-user' => null,
        );

        return $this->__soapCall('doSearch', array('session-handle' => $this->session['session-handle-part'],$searchQuery) );
    }

    public function getCategoryPath($cat_id)
    {
        try
        {
            return $this->doGetCategoryPath($this->session['session-handle-part'],$cat_id);
        }
        catch (\SoapFault $error)
        {
            $this->soapFaultError($error);
        }
    }

    private function _setParams()
    {
        $this->user_key = $this->Container->getParameter('allegro_key');
        $this->user_login = $this->Container->getParameter('allegro_login');
        $this->user_pass = $this->Container->getParameter('allegro_password');
    }

    private function _getVerKeyFromFile()
    {
        if ((($handle = fopen($this->verKey_url, "r", 1)) !== FALSE))
        {
            $this->verKey = fgets($handle);
            fclose($handle);
        }
        else
        {
            $this->_saveVerKeyToFile();
        }
    }

    private function _saveVerKeyToFile()
    {
        if ((($handle = fopen($this->verKey_url, "w+", 1)) !== FALSE))
        {
            $this->_getVerKey();
            fputs($handle,$this->verKey);
            fclose($handle);
        }
        else
        {
            echo 'File no exist: "'.$this->verKey_url.'"';
        }
    }

    private function _login()
    {
        $base64_pass = base64_encode( hash('sha256', $this->user_pass, true) );
        $this->session = $this->doLoginEnc($this->user_login, $base64_pass, self::COUNTRY_PL, $this->user_key, $this->verKey);
    }

    private function _getVerKey()
    {
        echo 'Get new version';
        $version = $this->doQuerySysStatus(self::QUERY_ALLEGROWEBAPI, self::COUNTRY_PL, $this->user_key);
        $this->verKey = $version['ver-key'];
    }


    protected function get($service)
    {
        return $this->Container->get($service);
    }

    /**
     * @return \Doctrine\Bundle\DoctrineBundle\Registry
     */
    protected function getDoctrine()
    {
        return $this->Container->get('doctrine');
    }

    protected function viewErrors()
    {
        if(!empty($this->errors))
        {
            print_r($this->errors);
        }
    }

    protected function soapFaultError(\SoapFault $error)
    {
        switch ($error->faultcode)
        {
            case 'ERR_INVALID_VERSION_CAT_SELL_FIELDS' :    // błąd niepoprawnego klucza wersji pozwala nam zauważyć fakt iż coś w serwisie się zmieniło
                $this->_saveVerKeyToFile();
                $this->_login();
                break;
            default :
                echo 'ERROR: '. $error->faultcode. ': '. $error->faultstring. "\r\n";
                break;
        }
    }



}